/*****************************************************************************
*  LPC11U6x SCT Repetitive IRQ program
*
*  1. Use SCT1 timer to generate a 10 msec timer tick (interrupt driven).
*  2. Toggle P2_16 (green LED on LPCXpresso board) every 200 msec
*****************************************************************************/
#include "board.h"

void SCT1_Init(void);

void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);			                  		 		// enable the SCT1 clock

	Chip_SCT_Config(LPC_SCT1, SCT_CONFIG_32BIT_COUNTER |				// split timers, auto limit
							  SCT_CONFIG_AUTOLIMIT_L   );


	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_0, SystemCoreClock/100);	// match on (half) PWM period
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, SystemCoreClock/100);


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_STATE0);	 		// event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0,(CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH0 	|	// MATCHSEL[3:0]   = related to match 0
                                                                        SCT_COMBMODE_MATCH  |	// COMBMODE[13:12] = match condition only
                                                                        SCT_STATELD_0		    |	// STATELD [14]    = STATEV is added to state
                                                                        SCT_STATEEV_0		    ));	// STATEV  [15]    = no state change


	Chip_SCT_EnableEventInt(LPC_SCT1, SCT_EVT_0);						// event 0 generates an interrupt

	NVIC_EnableIRQ(SCT0_1_IRQn);										// enable SCT interrupt

	Chip_SCT_ClearControl(LPC_SCT1,SCT_CTRL_HALT_L);	   				// unhalt it by clearing bit 2 of the CTRL register

}




void SCT0_1_IRQHandler(void)
{
	static uint8_t cnt = 0;

	if (++cnt > 20)                                					// 20 * 10 msec = 200 msec
	{
		cnt = 0;
		Chip_GPIO_SetPinToggle(LPC_GPIO, 2, 16);					// toggle pin P2_16
	}
	Chip_SCT_ClearEventFlag(LPC_SCT1, SCT_EVT_0);					// clear event 0 flag

}


int main (void)
{

	SystemCoreClockUpdate();
	Board_Init();

	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				// enable clock for IOCON

	Chip_GPIO_SetPinDIR(LPC_GPIO, 2, 16, true);						// configure P2.16 (green LED) as output


	SCT1_Init();                                   					// Initialize SCT


	while (1)                                              			// loop forever
	{
		__WFI();
	}
}

